<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\CategoryController;
use App\Http\Controllers\Api\BannerController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\CourseController;
use App\Http\Controllers\Api\NewsController;
use App\Http\Controllers\Api\QuizController;
use App\Http\Controllers\Api\EnrollmentController;

// Admin Controllers
use App\Http\Controllers\Admin\AuthController as AdminAuthController;
use App\Http\Controllers\Admin\UserController as AdminUserController;
use App\Http\Controllers\Admin\CourseController as AdminCourseController;
use App\Http\Controllers\Admin\CertificateController as AdminCertificateController;
use App\Http\Controllers\Admin\AnalyticsController as AdminAnalyticsController;
use App\Http\Controllers\Admin\ProgressController as AdminProgressController;
use App\Http\Controllers\Admin\MessageController as AdminMessageController;
use App\Http\Controllers\Admin\CategoryController as AdminCategoryController;
use App\Http\Controllers\Admin\SubcategoryController as AdminSubcategoryController;
use App\Http\Controllers\Admin\BannerController as AdminBannerController;
use App\Http\Controllers\Admin\NewsController as AdminNewsController;
use App\Http\Controllers\Admin\SettingController as AdminSettingController;
use App\Http\Controllers\Admin\MediaController as AdminMediaController;
use App\Http\Controllers\Admin\DashboardController as AdminDashboardController;
use App\Http\Controllers\Admin\CourseModuleController as AdminCourseModuleController;
use App\Http\Controllers\Admin\ReviewController as AdminReviewController;
use App\Http\Controllers\AiQuizController;
use App\Http\Controllers\AiQuizTestController;
use App\Http\Controllers\PdfTestController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

// Health Check Route
Route::get('/health', function () {
    return response()->json([
        'status' => 'OK',
        'message' => 'Exporters Point API is running',
        'timestamp' => now()->toISOString(),
        'version' => '0.1.1'
    ]);
});

// Development Routes (for testing sample data)
Route::prefix('dev')->group(function () {
    Route::post('/create-sample-categories', [CategoryController::class, 'createSampleData']);
    Route::post('/create-sample-banners', [BannerController::class, 'createSampleData']);
});

// Authentication Routes (Firebase + MySQL Hybrid)
Route::prefix('auth')->group(function () {
    Route::post('/sync-user', [AuthController::class, 'syncUser']);
    Route::post('/verify-phone', [AuthController::class, 'verifyPhone']);
    Route::post('/confirm-phone', [AuthController::class, 'confirmPhone']);
    Route::post('/logout/{firebaseUid}', [AuthController::class, 'logout']);
});

// User Management Routes
Route::prefix('users')->group(function () {
    Route::get('/firebase/{firebaseUid}/profile', [UserController::class, 'getProfile']);
    Route::put('/firebase/{firebaseUid}/profile', [UserController::class, 'updateProfile']);
    Route::post('/firebase/{firebaseUid}/upload-avatar', [UserController::class, 'uploadAvatar']);
    Route::get('/firebase/{firebaseUid}/dashboard', [UserController::class, 'getDashboard']);
    Route::get('/firebase/{firebaseUid}/notifications', [UserController::class, 'getNotifications']);
    Route::get('/{firebaseUid}/courses/enrolled', [EnrollmentController::class, 'getEnrolledCourses']);
    Route::get('/{firebaseUid}/quiz-results/{quizId}', [QuizController::class, 'getUserQuizResults']);
    Route::get('/{firebaseUid}/cart', [EnrollmentController::class, 'getCart']);
    Route::post('/{firebaseUid}/cart/add', [EnrollmentController::class, 'addToCart']);
    Route::delete('/{firebaseUid}/cart/{courseId}', [EnrollmentController::class, 'removeFromCart']);
    Route::get('/{firebaseUid}/certificates', [EnrollmentController::class, 'getCertificates']);
});

// Categories and Courses Routes
Route::prefix('categories')->group(function () {
    Route::get('/', [CategoryController::class, 'index']);
    Route::get('/{categoryId}/subcategories', [CategoryController::class, 'getSubcategories']);
});

Route::prefix('courses')->group(function () {
    Route::get('/', [CourseController::class, 'getAllCourses']);
    Route::get('/search', [CourseController::class, 'searchCourses']);
    Route::get('/featured', [CourseController::class, 'getFeaturedCourses']);
    Route::get('/latest', [CourseController::class, 'getLatestCourses']);
    Route::get('/category/{categoryId}', [CourseController::class, 'getCoursesByCategory']);
    Route::get('/subcategory/{subcategoryId}', [CourseController::class, 'getCoursesBySubcategory']);
    Route::get('/{courseId}', [CourseController::class, 'getCourseDetails']);
    Route::get('/{courseId}/lessons', [CourseController::class, 'getCourseLessons']);
    Route::get('/{courseId}/reviews', [CourseController::class, 'getCourseReviews']);
    Route::post('/{courseId}/reviews', [CourseController::class, 'submitReview']);
    Route::get('/{courseId}/quizzes', [QuizController::class, 'getCourseQuizzes']);
    Route::post('/{courseId}/enroll', [EnrollmentController::class, 'enrollCourse']);
});

// Quiz Routes - Mobile App Quiz System
Route::prefix('quizzes')->group(function () {
    Route::get('/{quizId}/questions', [QuizController::class, 'getQuizQuestions']);
    Route::post('/{quizId}/submit', [QuizController::class, 'submitQuiz']);
});

// AI Quiz Routes - Ephemeral Quiz Generation & Grading
Route::prefix('ai-quiz')->group(function () {
    Route::get('/test', [AiQuizTestController::class, 'test']);
    Route::get('/test-generation', [AiQuizTestController::class, 'testGeneration']);
    Route::get('/test-quiz', [AiQuizTestController::class, 'testQuizGeneration']);
    Route::get('/test-pdf', [PdfTestController::class, 'testPdf']);
    Route::get('/test-quiz-pdf', [PdfTestController::class, 'testQuizWithPdf']);
    Route::post('/start', [AiQuizController::class, 'start']);
    Route::post('/grade', [AiQuizController::class, 'grade']);
    Route::get('/progress', [AiQuizController::class, 'progress']);
    Route::get('/history', [AiQuizController::class, 'history']);
});

// Banner Management Routes
Route::prefix('banners')->group(function () {
    Route::get('/active', [BannerController::class, 'getActiveBanners']);
    Route::post('/{bannerId}/view', [BannerController::class, 'trackView']);
    Route::post('/{bannerId}/click', [BannerController::class, 'trackClick']);
});

// News Management Routes
Route::prefix('news')->group(function () {
    Route::get('/', [NewsController::class, 'getNewsArticles']);
    Route::get('/categories', [NewsController::class, 'getNewsCategories']);
    Route::get('/featured', [NewsController::class, 'getFeaturedNews']);
    Route::get('/search', [NewsController::class, 'searchNews']);
    Route::get('/{articleId}', [NewsController::class, 'getSingleArticle']);
});

// Content Management Routes
Route::prefix('content')->group(function () {
    Route::get('/about-us', function () {
        return response()->json(['message' => 'About us content endpoint - To be implemented']);
    });
    Route::get('/contact', function () {
        return response()->json(['message' => 'Contact info endpoint - To be implemented']);
    });
    Route::post('/contact/submit', function () {
        return response()->json(['message' => 'Contact form submission endpoint - To be implemented']);
    });
    Route::get('/featured', function () {
        return response()->json(['message' => 'Featured content endpoint - To be implemented']);
    });
});

// Payment Routes
Route::prefix('payments')->group(function () {
    Route::post('/process', function () {
        return response()->json(['message' => 'Process payment endpoint - To be implemented']);
    });
    Route::post('/verify', function () {
        return response()->json(['message' => 'Verify payment endpoint - To be implemented']);
    });
    Route::get('/methods', function () {
        return response()->json(['message' => 'Payment methods endpoint - To be implemented']);
    });
});

// Progress tracking and certificates
Route::put('/courses/{courseId}/lessons/{lessonId}/progress', [EnrollmentController::class, 'updateProgress']);
Route::post('/certificates/generate', [EnrollmentController::class, 'generateCertificate']);

// Search and suggestions
Route::get('/search/suggestions', [CourseController::class, 'getSearchSuggestions']);

// Analytics tracking
Route::post('/analytics/track-event', [EnrollmentController::class, 'trackEvent']);

// Analytics Routes
Route::prefix('analytics')->group(function () {
    Route::get('/categories/popular', function () {
        return response()->json(['message' => 'Popular categories endpoint - To be implemented']);
    });
    Route::get('/categories/{categoryId}/stats', function () {
        return response()->json(['message' => 'Category stats endpoint - To be implemented']);
    });
    Route::get('/banners/click-through', function () {
        return response()->json(['message' => 'Banner analytics endpoint - To be implemented']);
    });
    Route::get('/courses/trending', function () {
        return response()->json(['message' => 'Trending courses endpoint - To be implemented']);
    });
    Route::post('/track', function () {
        return response()->json(['message' => 'Track activity endpoint - To be implemented']);
    });
});

// Admin Routes - Dashboard Management APIs
Route::prefix('admin')->group(function () {
    
    // Authentication & Session Management
    Route::prefix('auth')->group(function () {
        Route::post('/login', [AdminAuthController::class, 'login']);
        Route::post('/logout', [AdminAuthController::class, 'logout']);
        Route::get('/me', [AdminAuthController::class, 'me']);
    });
    
    // Admin Profile (alias for auth/me)
    Route::get('/profile', [AdminAuthController::class, 'me']);
    
    // Dashboard Overview
    Route::get('/dashboard/overview', [AdminDashboardController::class, 'overview']);
    
    // User Management
    Route::prefix('users')->group(function () {
        Route::get('/', [AdminUserController::class, 'index']);
        Route::post('/', [AdminUserController::class, 'store']);
        Route::get('/{userId}', [AdminUserController::class, 'show']);
        Route::put('/{userId}', [AdminUserController::class, 'update']);
        Route::put('/{userId}/status', [AdminUserController::class, 'updateStatus']);
        Route::delete('/{userId}', [AdminUserController::class, 'destroy']);
    });
    
    // Instructors
    Route::get('/instructors', [AdminUserController::class, 'getInstructors']);
    
    // Course Management
    Route::prefix('courses')->group(function () {
        Route::get('/', [AdminCourseController::class, 'index']);
        Route::post('/', [AdminCourseController::class, 'store']);
        Route::get('/statistics', [AdminCourseController::class, 'statistics']);
        Route::get('/{courseId}', [AdminCourseController::class, 'show']);
        Route::put('/{courseId}', [AdminCourseController::class, 'update']);
        Route::delete('/{courseId}', [AdminCourseController::class, 'destroy']);
        Route::put('/{courseId}/status', [AdminCourseController::class, 'toggleStatus']);
        Route::put('/{courseId}/featured', [AdminCourseController::class, 'toggleFeatured']);
        
        // Course Modules Management
        Route::prefix('{courseId}/modules')->group(function () {
            Route::get('/', [AdminCourseModuleController::class, 'index']);
            Route::post('/', [AdminCourseModuleController::class, 'store']);
            Route::post('/reorder', [AdminCourseModuleController::class, 'reorder']);
            Route::get('/{moduleId}', [AdminCourseModuleController::class, 'show']);
            Route::put('/{moduleId}', [AdminCourseModuleController::class, 'update']);
            Route::delete('/{moduleId}', [AdminCourseModuleController::class, 'destroy']);
        });
    });
    
    // Certificate Management
    Route::prefix('certificates')->group(function () {
        Route::get('/', [AdminCertificateController::class, 'index']);
        Route::get('/{certificateId}', [AdminCertificateController::class, 'show']);
        Route::put('/{certificateId}/status', [AdminCertificateController::class, 'updateStatus']);
        Route::get('/{certificateId}/download', [AdminCertificateController::class, 'download']);
    });
    
    // User Progress & Quizzes
    Route::prefix('progress')->group(function () {
        Route::get('/', [AdminProgressController::class, 'index']);
        Route::get('/{userId}', [AdminProgressController::class, 'show']);
    });
    
    // Platform Messaging
    Route::prefix('messages')->group(function () {
        Route::get('/', [AdminMessageController::class, 'index']);
        Route::post('/', [AdminMessageController::class, 'store']);
    });
    
    // Analytics & Dashboard
    Route::prefix('analytics')->group(function () {
        Route::get('/dashboard', [AdminAnalyticsController::class, 'dashboard']);
        Route::get('/users', [AdminAnalyticsController::class, 'userAnalytics']);
        Route::get('/courses', [AdminAnalyticsController::class, 'courseAnalytics']);
        Route::get('/revenue', [AdminAnalyticsController::class, 'revenueAnalytics']);
    });
    
    // Categories Management
    Route::prefix('categories')->group(function () {
        Route::get('/', [AdminCategoryController::class, 'index']);
        Route::post('/', [AdminCategoryController::class, 'store']);
        Route::get('/statistics', [AdminCategoryController::class, 'statistics']);
        Route::post('/reorder', [AdminCategoryController::class, 'reorder']);
        Route::get('/{id}', [AdminCategoryController::class, 'show']);
        Route::put('/{id}', [AdminCategoryController::class, 'update']);
        Route::delete('/{id}', [AdminCategoryController::class, 'destroy']);
        Route::put('/{id}/status', [AdminCategoryController::class, 'updateStatus']);
    });
    
    // Subcategories Management
    Route::prefix('subcategories')->group(function () {
        Route::get('/', [AdminSubcategoryController::class, 'index']);
        Route::post('/', [AdminSubcategoryController::class, 'store']);
        Route::get('/statistics', [AdminSubcategoryController::class, 'statistics']);
        Route::post('/reorder', [AdminSubcategoryController::class, 'reorder']);
        Route::get('/category/{categoryId}', [AdminSubcategoryController::class, 'getByCategory']);
        Route::get('/{id}', [AdminSubcategoryController::class, 'show']);
        Route::put('/{id}', [AdminSubcategoryController::class, 'update']);
        Route::delete('/{id}', [AdminSubcategoryController::class, 'destroy']);
        Route::put('/{id}/status', [AdminSubcategoryController::class, 'updateStatus']);
    });
    
    // Banners Management
    Route::prefix('banners')->group(function () {
        Route::get('/', [AdminBannerController::class, 'index']);
        Route::post('/', [AdminBannerController::class, 'store']);
        Route::get('/statistics', [AdminBannerController::class, 'statistics']);
        Route::post('/reorder', [AdminBannerController::class, 'reorder']);
        Route::get('/{id}', [AdminBannerController::class, 'show']);
        Route::put('/{id}', [AdminBannerController::class, 'update']);
        Route::delete('/{id}', [AdminBannerController::class, 'destroy']);
        Route::put('/{id}/status', [AdminBannerController::class, 'updateStatus']);
        Route::get('/{id}/analytics', [AdminBannerController::class, 'analytics']);
        Route::post('/{id}/duplicate', [AdminBannerController::class, 'duplicate']);
    });
    
    // News Management
    Route::prefix('news')->group(function () {
        Route::get('/', [AdminNewsController::class, 'index']);
        Route::post('/', [AdminNewsController::class, 'store']);
        Route::get('/categories', [AdminNewsController::class, 'getCategories']);
        Route::get('/statistics', [AdminNewsController::class, 'statistics']);
        Route::get('/{id}', [AdminNewsController::class, 'show']);
        Route::put('/{id}', [AdminNewsController::class, 'update']);
        Route::delete('/{id}', [AdminNewsController::class, 'destroy']);
        Route::put('/{id}/status', [AdminNewsController::class, 'updateStatus']);
        Route::put('/{id}/featured', [AdminNewsController::class, 'updateFeatured']);
        Route::post('/{id}/duplicate', [AdminNewsController::class, 'duplicate']);
    });
    
    // Settings Management
    Route::prefix('settings')->group(function () {
        Route::get('/', [AdminSettingController::class, 'index']);
        Route::post('/', [AdminSettingController::class, 'store']);
        Route::get('/groups', [AdminSettingController::class, 'getGroups']);
        Route::get('/public', [AdminSettingController::class, 'getPublicSettings']);
        Route::get('/export', [AdminSettingController::class, 'export']);
        Route::post('/bulk-update', [AdminSettingController::class, 'updateBulk']);
        Route::post('/reset-defaults', [AdminSettingController::class, 'resetToDefaults']);
        Route::get('/group/{group}', [AdminSettingController::class, 'getByGroup']);
        Route::get('/key/{key}', [AdminSettingController::class, 'getByKey']);
        Route::get('/{id}', [AdminSettingController::class, 'show']);
        Route::put('/{id}', [AdminSettingController::class, 'update']);
        Route::delete('/{id}', [AdminSettingController::class, 'destroy']);
    });
    
    // Media Management
    Route::prefix('media')->group(function () {
        Route::get('/', [AdminMediaController::class, 'index']);
        Route::post('/upload', [AdminMediaController::class, 'upload']);
        Route::post('/upload-multiple', [AdminMediaController::class, 'uploadMultiple']);
        Route::get('/folders', [AdminMediaController::class, 'getFolders']);
        Route::get('/statistics', [AdminMediaController::class, 'statistics']);
        Route::delete('/bulk-delete', [AdminMediaController::class, 'destroyMultiple']);
        Route::get('/{id}', [AdminMediaController::class, 'show']);
        Route::put('/{id}', [AdminMediaController::class, 'update']);
        Route::delete('/{id}', [AdminMediaController::class, 'destroy']);
    });
    
    // Review Management
    Route::prefix('reviews')->group(function () {
        Route::get('/', [AdminReviewController::class, 'index']);
        Route::delete('/{reviewId}', [AdminReviewController::class, 'destroy']);
    });
    
});

// Fallback route for undefined API endpoints
Route::fallback(function () {
    return response()->json([
        'success' => false,
        'message' => 'API endpoint not found',
        'available_endpoints' => [
            'GET /api/health - Health check',
            'POST /api/auth/sync-user - Sync Firebase user to MySQL',
            'GET /api/categories - Get all categories',
            'GET /api/banners/active - Get active banners',
            'POST /api/dev/create-sample-categories - Create sample categories',
            'POST /api/dev/create-sample-banners - Create sample banners',
            'GET /api/news - Get news articles',
            'GET /api/content/about-us - Get about us content',
            'POST /api/content/contact/submit - Submit contact form'
        ]
    ], 404);
});