-- =====================================================
-- EXPORTERS POINT API - PRODUCTION UPDATE v0.6.0
-- =====================================================
-- Date: 2025-08-21
-- Purpose: Update production database with latest changes
-- Database: MySQL (Production)
-- =====================================================

-- 1. Update all courses with empty PDF paths to have default PDF
UPDATE courses 
SET course_pdf_path = 'https://www.math.uci.edu/~mzeman/M13-19F/math-13-notes.pdf'
WHERE course_pdf_path IS NULL OR course_pdf_path = '';

-- 2. Add sample featured courses (if not exists)
INSERT IGNORE INTO courses (
    category_id, title, description, price, currency, level, language, 
    is_featured, is_active, course_pdf_path, created_at, updated_at
) VALUES 
('cat_uuzaji_nje', 'International Export Business', 
 'Learn the fundamentals of international export business and grow your market reach globally.', 
 50000, 'TZS', 'Beginner', 'English', 1, 1, 
 'https://www.math.uci.edu/~mzeman/M13-19F/math-13-notes.pdf',
 NOW(), NOW()),

('cat_masoko', 'Digital Marketing for Exporters', 
 'Master digital marketing strategies specifically designed for export businesses.', 
 75000, 'TZS', 'Intermediate', 'English', 1, 1,
 'https://www.math.uci.edu/~mzeman/M13-19F/math-13-notes.pdf',
 NOW(), NOW()),

('cat_sheria', 'Export Legal Framework', 
 'Understand the legal requirements and frameworks for successful export operations.', 
 60000, 'TZS', 'Advanced', 'English', 1, 1,
 'https://www.math.uci.edu/~mzeman/M13-19F/math-13-notes.pdf',
 NOW(), NOW());

-- 3. Ensure all required migrations have been run
-- Check if these migrations exist in your production migrations table:
-- - 2024_01_01_000001_create_quiz_attempts_table
-- - 2024_01_01_000002_create_quiz_attempt_items_table  
-- - 2025_07_25_071936_add_course_columns_to_courses_table
-- - 2025_07_25_072313_add_subcategory_id_to_courses_table
-- - 2025_07_25_074650_add_role_to_users_table
-- - 2025_07_28_062603_create_course_modules_table
-- - 2025_07_28_062659_add_pdf_youtube_fields_to_courses_table
-- - 2025_08_11_080526_add_missing_columns_to_course_reviews_table
-- - 2025_08_11_083950_add_missing_columns_to_enrollments_table

-- 4. If any migrations are missing, run them using Laravel artisan:
-- php artisan migrate

-- =====================================================
-- VERIFICATION QUERIES (Run after update)
-- =====================================================

-- Check course PDF paths are updated
-- SELECT id, title, course_pdf_path FROM courses WHERE course_pdf_path IS NULL OR course_pdf_path = '';

-- Check featured courses exist
-- SELECT id, title, is_featured FROM courses WHERE is_featured = 1;

-- Check migrations status
-- SELECT * FROM migrations WHERE migration LIKE '%2025%' OR migration LIKE '%quiz%';

-- =====================================================
-- END OF PRODUCTION UPDATE
-- =====================================================